/* ============ */
/* execkosm.c	*/
/* ============ */
#include <mconf.h>
#include <miscdefs.h>
#include <freqdefs.h>
/* ==================================================================== */
/* ExecKolSmirTest - Performs K-S on K-S Test on Runs of Random Numbers	*/
/* ==================================================================== */
void
ExecKolSmirTest(KS_DATA_STRU *KSData)
{
    int     i;
    double  NegProbAry[MAX_KS_RUNS], PosProbAry[MAX_KS_RUNS];
    double  KnMinusProb, KnMinusStat, KnPlusProb, KnPlusStat;

    /* ---------------------------------- */
    /* Set Run Controls from User Inputs. */
    /* ---------------------------------- */
    SetKoSmControls(KSData);

    /* ------------------------ */
    /* Initialize Variate Count */
    /* ------------------------ */
    KSData->TotNumGen = 0;

    /* ----------------------------- */
    /* Gather Data for KS-on-KS Test */
    /* ----------------------------- */
    fflush(NULL);
    for (i = 0; i < KSData->NumKSRuns; ++i)
    {
	KSFreq(KSData);

	PosProbAry[i] = KSData->KnPlusProb;
	NegProbAry[i] = KSData->KnMinusProb;

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    i+1, KSData->NumKSRuns, KSData->TotNumGen);
    }

    fprintf(stderr, "\n"); fflush(NULL);
    /* ---------------------------------------------- */
    /* Calculate Statistics and Probabilities for Kn+ */
    /* ---------------------------------------------- */
    KSCalc(PosProbAry, KSData->NumKSRuns, &KnPlusStat, &KnPlusProb,
	&KnMinusStat, &KnMinusProb);

    printf("\nStatistics and Probabilities for Kn+\n");

    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", KSData->NumKSRuns,
	sqrt((double)KSData->NumKSRuns)*KnPlusStat, 100*KnPlusProb);

    printf("\tK(%d)- = %f (Knuth) or %9f%%\n", KSData->NumKSRuns,
	sqrt((double)KSData->NumKSRuns)*KnMinusStat, 100*KnMinusProb);

    /* ---------------------------------------------- */
    /* Calculate Statistics and Probabilities for Kn- */
    /* ---------------------------------------------- */
    KSCalc(NegProbAry, KSData->NumKSRuns, &KnPlusStat, &KnPlusProb,
	&KnMinusStat, &KnMinusProb);

    printf("\nStatistics and Probabilities for Kn-\n");

    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", KSData->NumKSRuns,
	sqrt((double)KSData->NumKSRuns)*KnPlusStat, 100*KnPlusProb);

    printf("\tK(%d)- = %f (Knuth) or %9f%%\n", KSData->NumKSRuns,
	sqrt((double)KSData->NumKSRuns)*KnMinusStat, 100*KnMinusProb);

    printf("\nThis Run Required %ld Random Numbers\n\n",
	KSData->TotNumGen);
}
